import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.swing.JLabel;
import javax.swing.JPanel;

import dragNdrop.CifFileDropper;
import dragNdrop.CifFileOpener;

/* EscherFFT - FftCanvas.java
 * 
 * Author   : Nicolas Schoeni
 * Creation : 29 mai 2006
 * 
 * nicolas.schoeni@epfl.ch
 */

public class OutputCanvas extends GenericCanvas implements CifFileOpener {
	private OutputSystem outputSystem;
	public  ComplexImage complexImage;
	public  float scale = 1;
	private int dx, dy, cw, ch;
	public  BufferedImage originalCellImage;
	public  int originalCellW, originalCellH, originalCellOffset;
	
	public void openFile(File f) {
		outputSystem.mainPane.openFile(f, false);
	}

	public OutputCanvas(int size, String name, boolean inverse, final OutputSystem outputSystem) {
		this.name=name;
		this.outputSystem=outputSystem;
		complexImage = new ComplexImage(size, inverse, outputSystem.complexImageSystem);

		setPreferredSize(new Dimension(outputSystem.size, outputSystem.size));
		new DropTarget(this, new CifFileDropper(this));
		
		setBackground(new JPanel().getBackground());
		addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				float s = (float)scale+scale*(e.getWheelRotation()/20f);
				int z = (int)Math.round(scale*100);
				if (s*100<outputSystem.tools.zoomSlider.slider.getMinimum()) {
					z=100;
					s=1;
				}
				if (s*100>outputSystem.tools.zoomSlider.slider.getMaximum()) {
					z=outputSystem.tools.zoomSlider.slider.getMaximum();
					s=z/100f;
				}
				if (z>=outputSystem.tools.zoomSlider.slider.getMinimum() && z<=outputSystem.tools.zoomSlider.slider.getMaximum()) {						
					outputSystem.tools.zoomSlider.slider.setValue(z);
					scale = s;
					repaint();
				}
			}
		});
		addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseMoved(MouseEvent e) {
				if (cw==0||ch==0) return;
				int x = (int)Math.round((e.getX()-dx)*outputSystem.size/cw);
				int y = (int)Math.round((e.getY()-dy)*outputSystem.size/ch);
				complexImage.setLabelValue(x, y, outputSystem.mainPane.posLabel);
			}
		});
	}

	public String toString() {
		return name;
	}

	public void destroy() {
		complexImage.destroy();
		if (originalCellImage!=null) originalCellImage.flush();
		originalCellImage=null;
	}

	public void updateImageBuffer() {
		Graphics g = outputSystem.imageBuffer.getGraphics();
		if (outputSystem.outputMask) {
			g.setColor(getBackground());
			g.fillRect(0, 0, outputSystem.size, outputSystem.size);
			int d = (int)Math.round(outputSystem.outputMaskRadius*scale);
			g.setClip(new Ellipse2D.Float((outputSystem.size-d)/2, (outputSystem.size-d)/2, d, d));
		}

		cw = (int)Math.round(outputSystem.size*scale);
		ch = (int)Math.round(outputSystem.size*scale);
		dx = (outputSystem.size-cw)/2;
		dy = (outputSystem.size-ch)/2;
		g.drawImage(outputSystem.currentCanvas.complexImage.image, dx, dy, cw+dx, ch+dy, 0, 0, outputSystem.size, outputSystem.size, null);
		g.setClip(null);
	}

	public void paint(Graphics g) {
		g.setColor(getBackground());
		g.fillRect(0, 0, getWidth(), getHeight());
		g.drawImage(outputSystem.imageBuffer, (getWidth()-complexImage.size)/2, (getHeight()-complexImage.size)/2, null);
	}

	public BufferedImage getImage() {
		return complexImage.image;
	}

	public void createCellOverlay(DrawCanvas drawCanvas) {
		if (originalCellImage!=null) originalCellImage.flush();
		if (!drawCanvas.periodicity) {
			originalCellImage=null;
		}
		else {
			originalCellImage = DrawCanvas.createTransparentImage(drawCanvas.cell.a+drawCanvas.cell.offset, drawCanvas.cell.h);
			drawCanvas.drawCellOverlay(originalCellImage.getGraphics(), 0, 0);
			originalCellW = drawCanvas.cell.a;
			originalCellH = drawCanvas.cell.h;
			originalCellOffset = drawCanvas.cell.offset;
		}
	}
	
	
	public void loadImage(BufferedImage image) {
		complexImage.load(image);
		complexImage.updateReIm2HSB();
		complexImage.updateHSB2image();
		updateImageBuffer();
		repaint();
	}
}
