import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import utils.HVPanel;

import dragNdrop.CifFileOpener;

/* EscherFFT - MainPane.java
 * 
 * Author   : Nicolas Schoeni
 * Creation : 27 fvr. 2006
 * 
 * nicolas.schoeni@epfl.ch
 */

public class MainPane implements CifFileOpener {
	private final static int IMAGE_SIZE = 512;
	
	public  final JPanel jPanel;
	public  DrawSystem drawSystem;
	public  OutputSystem outputSystem;
	private Tools tools;
	public  JLabel posLabel;
	private JButton advancedButton;
	private AdvancedPane advancedPane;
	public  JProgressBar memoryBar;
	public  FFT applet;
	
	public void destroy() {
		drawSystem.destroy();
		outputSystem.destroy();
	}
	public void stop() {
		advancedPane.show(false);
	}
	
	public MainPane(FFT applet) {
		this.applet=applet;
		printTotalMem();

		ToolTipManager.sharedInstance().setDismissDelay(20000);
		ToolTipManager.sharedInstance().setInitialDelay(500);
		ToolTipManager.sharedInstance().setReshowDelay(1);
		
		posLabel = new JLabel(" ");
		
		drawSystem = new DrawSystem(IMAGE_SIZE, this);
		drawSystem.addCanvas("image");
		
		outputSystem = new OutputSystem(IMAGE_SIZE, this);
		outputSystem.addCanvas("FFT(image)", false);
		
		tools = new Tools();
		advancedPane = new AdvancedPane(this);

		HVPanel.v pv = new HVPanel.v();
		HVPanel.h ph = new HVPanel.h();
		ph.expand(true);
		ph.addComp(drawSystem.tabbedPane);
		ph.addComp(outputSystem.tabbedPane);
		pv.expand(true);
		pv.addSubPane(ph);
		//HVPanel.v tv = new HVPanel.v();
		//tv.expand(false);
		//tv.addSubPane(tools);
		pv.expand(false);
		//JScrollPane sp = new JScrollPane(tools.jPanel, JScrollPane.VERTICAL_SCROLLBAR_NEVER, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		//sp.setPreferredSize(new Dimension(250, 150));
		//pv.addComp(sp);
		pv.addSubPane(tools);
		jPanel = pv.jPanel;
		
		drawSystem.tabbedPane.getComponentAt(0).setVisible(true);
		outputSystem.tabbedPane.getComponentAt(0).setVisible(true);

		drawSystem.setCurrentCanvas((DrawCanvas) drawSystem.drawCanvas.get(0));
		outputSystem.setCurrentCanvas((OutputCanvas) outputSystem.outputCanvas.get(0));

//		printUsedMem();
//		int size2=IMAGE_SIZE;
//		float[][] dataRe = new float[size2][size2];
//		float[][] dataIm = new float[size2][size2];
//		printUsedMem();
		
		
		//System.out.println("UsedMem:"+(Runtime.getRuntime().totalMemory()-Runtime.getRuntime().freeMemory())/1024/1024+"Mb");
//		BufferedImage[] ii = new BufferedImage[10];
//		for (int i=0; i<ii.length; i++) {
//			ii[i] = new BufferedImage(512, 512, BufferedImage.TYPE_INT_RGB);
//		}
		//DrawCanvas d1 = new DrawCanvas(IMAGE_SIZE, posLabel);
		
		
		printUsedMem();
	}
	
	public String getTotalMemMB() {
		return ""+Runtime.getRuntime().maxMemory()*10/1024/1024/10f+" MB";
	}
	public void printTotalMem() {
		System.out.println("MaxMem:"+getTotalMemMB());
	}
	public void printUsedMem() {
		final String s = (Runtime.getRuntime().totalMemory()-Runtime.getRuntime().freeMemory())*10/1024/1024/10f+" MB";
		//System.out.println("UsedMem:"+s);
		if (memoryBar!=null) {
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					memoryBar.setValue((int)((Runtime.getRuntime().totalMemory()-Runtime.getRuntime().freeMemory())/1024));
					memoryBar.setString(s);
				}
			});
		}
	}
	
	public void showOutOfMem(JFrame parent, String action) {
		JOptionPane.showMessageDialog(parent==null?applet.frame:parent, "Not enough memory"+action+".\nPlease close one or more tabs to free up some memory.\n\n(Java is currently configured to use "+getTotalMemMB()+" whatever how much system memory you have.\nPlease read the help if you want to learn how to increase the memory allowed to java applets.)", "Out of memory", JOptionPane.ERROR_MESSAGE);
	}
	
	public boolean isTabNameUnique(String name) {
		for (int i=0; i<drawSystem.drawCanvas.size(); i++) {
			GenericCanvas c = (GenericCanvas) drawSystem.drawCanvas.get(i);
			if (c.name.equals(name)) return false;
		}
		for (int i=0; i<outputSystem.outputCanvas.size(); i++) {
			OutputCanvas c = (OutputCanvas) outputSystem.outputCanvas.get(i);
			if (c.name.equals(name)) return false;
		}
		return true;
	}
	public String makeTabNameUnique(String name) {
		StringBuffer sb = new StringBuffer(name);
		while (!isTabNameUnique(sb.toString())) {
			sb.append("'");
		}
		return sb.toString();
	}
	
	
	
	
	class Tools extends HVPanel.h {
		private JButton fftButton, fftBackButton;

		public Tools() {
			expand(false);
			left();
			addSubPane(drawSystem.tools);
			
			center();
			expand(true);
			putExtraSpace();
			expand(false);

			HVPanel.v p9 = new HVPanel.v();
			p9.expand(false);
			HVPanel.v p91 = new HVPanel.v("Transform");
			p91.expand(false);
			p91.center();
			p91.addButton(fftButton=new JButton("\u2192      FFT"));
			p91.addButton(fftBackButton=new JButton("FFT-1      \u2190"));
			HVPanel.h p8 = new HVPanel.h();
			p8.expand(false);
			p8.addSubPane(p91);
			p9.addSubPane(p8);
			p9.putExtraSpace();
			
			HVPanel.v p92 = new HVPanel.v();
			HVPanel.h p82 = new HVPanel.h();
			p82.expand(false);
			p82.addButton(advancedButton=new JButton("Advanced"));
			p92.addSubPane(p82);
			p9.addSubPane(p92);
			
			HVPanel.h p7 = new HVPanel.h();
			Dimension d = new Dimension(250, 16);
			p7.jPanel.setPreferredSize(d);
			p7.jPanel.setMinimumSize(d);
			p7.jPanel.setMaximumSize(d);
			p7.expand(false);
			p7.addComp(posLabel);
			p9.addSubPane(p7);
			addSubPane(p9);

			expand(true);
			putExtraSpace();
			expand(false);
			right();

			addSubPane(outputSystem.tools);
		}
		
		public void actionPerformed(ActionEvent e) {
			if (e.getSource()==fftButton) {
				try {
					String s = "FFT("+(drawSystem.currentCanvas==null?(GenericCanvas)drawSystem.backCanvas:(GenericCanvas)drawSystem.currentCanvas).name+")";
					OutputCanvas c = outputSystem.getCanvas(s);
					if (c==null) {
						c = outputSystem.addCanvas(s, false);
						advancedPane.addRightSideFile(s);
					}
					outputSystem.showCanvas(s);
					long t0 = System.currentTimeMillis();
					if (drawSystem.currentCanvas==null) {
						if (drawSystem.backCanvas!=null) {
							outputSystem.currentCanvas.complexImage.load(drawSystem.backCanvas.size, drawSystem.backCanvas.dataRe, drawSystem.backCanvas.dataIm);
							outputSystem.currentCanvas.complexImage.doFFT();
						}
						else return;
					}
					else {
						outputSystem.currentCanvas.complexImage.load(drawSystem.currentCanvas.getImage());
						outputSystem.currentCanvas.complexImage.doFFT();
						outputSystem.currentCanvas.createCellOverlay(drawSystem.currentCanvas); 
					}
					outputSystem.complexImageSystem.updateOutput(outputSystem.currentCanvas.complexImage);
					long t1 = System.currentTimeMillis();
					System.out.println("-> "+(t1-t0)+" ms");
					outputSystem.currentCanvas.updateImageBuffer();
					outputSystem.currentCanvas.repaint();
				} catch (OutOfMemoryError err) {
					System.err.println(err);
					showOutOfMem(null, " to do this action");
				}
			}
			else if (e.getSource()==fftBackButton) {
				try {
					String s = "FFT-1("+outputSystem.currentCanvas.name+")";
					GenericCanvas c = drawSystem.getCanvas(s);
					if (!(c instanceof BackCanvas)) {
						s = makeTabNameUnique(s);
						c = null;
					}
					if (c==null) {
						c = drawSystem.addBackCanvas(s, outputSystem);
						advancedPane.addLeftSideFile(s);
					}
					drawSystem.showCanvas(s);
					BackCanvas bc = (BackCanvas) c;
					long t0 = System.currentTimeMillis();
					bc.fftBack(outputSystem.currentCanvas);
					long t1 = System.currentTimeMillis();
					System.out.println("<- "+(t1-t0)+" ms");
					drawSystem.backCanvas.repaint();
				} catch (OutOfMemoryError err) {
					System.err.println(err);
					showOutOfMem(null, " to do this action");
				}
			}
			else if (e.getSource()==advancedButton) {
				advancedPane.show(true);
			}
		}
	}

	public void openFile(File f) {
		openFile(f, true);
	}
	public void openFile(File f, boolean left) {
		try {
			BufferedImage image = ImageIO.read(f);
			if (ImageAnalyser.analyse(image)==true) {
				ImageAnalyser.removeBorder(image);
			}
			
			if (image==null) {
				System.err.println("Bad file !");
				return;
			}
			String s = f.getName();
			s = s.replaceAll("\\.((jpeg)|(jpg)|(png)|(gif)|(JPEG)|(JPG)|(PNG)|(GIF))", "");
			s = makeTabNameUnique(s);
			if (left) {
				DrawCanvas c = drawSystem.addCanvas(s);
				c.loadImage(image);
				advancedPane.addLeftSideFile(s);
				drawSystem.tabbedPane.setSelectedIndex(drawSystem.tabbedPane.indexOfTab(s));
			}
			else {
				OutputCanvas c = outputSystem.addCanvas(s, false);
				if (image.getWidth()<IMAGE_SIZE||image.getHeight()<IMAGE_SIZE) {
					BufferedImage image2 = new BufferedImage(IMAGE_SIZE, IMAGE_SIZE, BufferedImage.TYPE_INT_RGB); 
					image2.getGraphics().drawImage(image, 0, 0, IMAGE_SIZE, IMAGE_SIZE, null);
					image.flush();
					image=image2;
				}
				c.loadImage(image);
				advancedPane.addRightSideFile(s);
				outputSystem.tabbedPane.setSelectedIndex(outputSystem.tabbedPane.indexOfTab(s));
			}
		} catch (IOException e) {
			e.printStackTrace(System.err);
  		JOptionPane.showMessageDialog(applet.frame, "Can't read file or bad format !");
		} catch (OutOfMemoryError e) {
			System.err.println(e);
			showOutOfMem(null, " to open this file");
		}
	}
}
