import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

/* EscherFFT - ImageAnalyser.java
 * 
 * Author   : Nicolas Schoeni
 * Creation : 9 juin 2006
 * 
 * nicolas.schoeni@epfl.ch
 */

public class ImageAnalyser {
	
	public static boolean analyse(BufferedImage image) {
		int border = hasBlackBorder(image)?1:0;
		if (border==1) System.out.println("Back border detected!");
		
		int black=0, white=0, gray=0; 
		int[] hues = new int[8];
		float[] hsb = new float[3];
		
		for (int i=border; i<image.getWidth()-border; i++) {
			for (int j=border; j<image.getHeight()-border; j++) {
				Color c = new Color(image.getRGB(i, j));
				int r = c.getRed();
				int g = c.getGreen();
				int b = c.getBlue();
				Color.RGBtoHSB(r, g, b, hsb);
				
				if (r==0&&g==0&&b==0) black++;
				else if (r==255&&g==255&&b==255) white++;
				else if (r==g&&r==b) gray++;
				else hues[(int)Math.floor((hsb[0]*8f+.5f)%8f)]++;
			}
		}
		int n = (image.getWidth()-border*2)*(image.getHeight()-border*2);
		System.out.print("black:"+v(black,n)+" white:"+v(white,n)+" gray:"+v(gray,n));
		n=n-black-white-gray;
		System.out.println(" ["+v(hues[0],n)+" "+v(hues[1],n)+" "+v(hues[2],n)+" "+v(hues[3],n)+" "+v(hues[4],n)+" "+v(hues[5],n)+" "+v(hues[6],n)+" "+v(hues[7],n)+"]");
		
		boolean realPos = isSignificative(hues[0]+hues[1]+hues[7], n);
		boolean realNeg = isSignificative(hues[3]+hues[4]+hues[5], n);
		boolean complex = isSignificative(hues[2]+hues[6], n);
		if (complex) System.out.println("--> complex");
		else if (realNeg) System.out.println("--> real");
		else if (realPos) System.out.println("--> positive real");
		else System.out.println("--> ???");
		return border==1;
	}
	
	public static boolean hasBlackBorder(BufferedImage image) {
		int c=0;
		for (int i=-2; i<2; i++) {
			for (int j=0; j<image.getHeight(); j++) {
				int rgb = image.getRGB((i+image.getWidth())%image.getWidth(), j);
				if (i==-2||i==1&&(rgb&0xffffff)!=0) c++;
				if (i==-1||i==0&&(rgb&0xffffff)==0) c++;
			}
		}
		for (int j=-2; j<2; j++) {
			for (int i=0; i<image.getWidth(); i++) {
				int rgb = image.getRGB(i, (j+image.getHeight())%image.getHeight());
				if (j==-2||j==1&&(rgb&0xffffff)!=0) c++;
				if (j==-1||j==0&&(rgb&0xffffff)==0) c++;
			}
		}
		int n=4*image.getHeight()+4*image.getWidth();
		return c==n-4;
	}
	
	public static void removeBorder(BufferedImage image) {
		Graphics g = image.getGraphics();
		g.setColor(Color.white);
		g.drawRect(0, 0, image.getWidth()-1, image.getHeight()-1);
	}
	
	private static String v(int v, int n) {
		return Math.round(1000f*(float)v/(float)n)/10f+"%";
	}
	private static boolean isSignificative(int v, int n) {
		return (float)v/(float)n>=0.05;
	}
}
