import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;

import javax.swing.JLabel;

/* EscherFFT - BackCanvas.java
 * 
 * Author   : Nicolas Schoeni
 * Creation : 2 juin 2006
 * 
 * nicolas.schoeni@epfl.ch
 */

public class BackCanvas extends GenericCanvas {
	private final OutputSystem outputSystem;
	public  final int size;
	public  float dataRe[][], dataIm[][];
	public BufferedImage image;
	
	public BackCanvas(String name, final int size, final OutputSystem outputSystem) {
		this.name=name;
		this.size=size;
		this.outputSystem=outputSystem;
		image = OutputSystem.createImage(size, Color.white);
		dataRe = new float[size][size];
		dataIm = new float[size][size];
		setPreferredSize(new Dimension(size, size));

		addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseMoved(MouseEvent e) {
				int x = e.getX(), y = e.getY();
				if (x<0||y<0||x>=size||y>=size) {
					outputSystem.mainPane.posLabel.setText(" ");
				}
				else {
					float re = dataRe[x][y];
					float im = dataIm[x][y];
					float a = (float)Math.sqrt(re*re+im*im);
					int phi = (int)Math.round(Math.atan2(im, re)*180f/Math.PI);
					re = Math.round(re*100f)/100f;
					im =  Math.round(im*100f)/100f;
					a =  Math.round(a*100f)/100f;
					if (a<0.001) phi=0;
//					float[] hsb = new float[3];
//					ComplexColor.complexToHSB(re/maxValue, im/maxValue, hsb, mode);			
//					Color c = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
//					label.setForeground(c);
					outputSystem.mainPane.posLabel.setText("Re="+re+" Im="+im+" A="+a+" \u03c6="+phi+"");
				}
			}
		});
	}
	
	public void fftBack(OutputCanvas c) {
		ComplexImage complexImage = outputSystem.complexImageSystem.getTempComplexImage(size, true, image);
		if (outputSystem.outputMask) {
			complexImage.load(c.complexImage, outputSystem.complexImageSystem.mode, outputSystem.outputMaskRadius);
		}
		else {
			complexImage.load(c.complexImage, outputSystem.complexImageSystem.mode);
		}
		complexImage.doFFT();
		complexImage.updateReIm2HSB();
		complexImage.updateHSB2image();
		for (int x=0; x<dataRe.length; x++) {
			for (int y=0; y<dataRe[x].length; y++) {
				int i=(x+complexImage.size2-size/2)%complexImage.size2, j=(y+complexImage.size2-size/2)%complexImage.size2;
				dataRe[x][y] = complexImage.dataRe[i][j];
				dataIm[x][y] =	complexImage.dataIm[i][j];
			}
		}
		complexImage.image = null;
		complexImage.destroy();
		Graphics g = image.getGraphics();
		if (c.originalCellImage!=null) {
			g.drawImage(c.originalCellImage, 0, 0, null);
			DrawCanvas.drawCell(g, Color.black, size/2, size/2-c.originalCellH, c.originalCellW, c.originalCellH, c.originalCellOffset);
		}
	}
	
	public void paint(Graphics g) {
		g.setColor(getBackground());
		g.fillRect(0, 0, getWidth(), getHeight());
		g.drawImage(image, (getWidth()-size)/2, (getHeight()-size)/2, null);
	}
	
	public BufferedImage getImage() {
		return image;
	}
	
	public void destroy() {
		image.flush();
		image=null;
	}
}
