import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

import javax.imageio.ImageIO;
import javax.swing.AbstractCellEditor;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.metal.MetalProgressBarUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.vecmath.Point3d;

import utils.HVPanel;
import utils.MultiLineToolTip;


/* EscherFFT - AdvancedPane.java
 * 
 * Author   : Nicolas Schoeni
 * Creation : 20 avr. 2006
 * 
 * nicolas.schoeni@epfl.ch
 */

public class AdvancedPane {
	private JFrame frame;
	private ContentPane pane;
	private MainPane mainPane;
	private int nextIndex = 2;
	private JListMutable currentDragSource;
	
	public AdvancedPane(MainPane mainPane) {
		this.mainPane = mainPane;
		
		frame = new JFrame("Advanced");
		pane = new ContentPane();
		frame.setContentPane(pane.jPanel);
		frame.setSize(670, 500);
		//frame.pack();
	}
	
	class CloseCanvasThread extends Thread {
		public void run() {
			System.gc();
			mainPane.printUsedMem();
		}
	}
	
	
	public void show(boolean show) {
	  frame.setVisible(show);
	  if (show) frame.toFront();
	}
	
	public void addLeftSideFile(String name) {
		pane.lp1.list.addElement(name);
		//pane.outputBox.addItem(name);
	}
	public void addRightSideFile(String name) {
		pane.lp2.list.addElement(name);
		pane.outputBox.addItem(name);
	}
	
	public boolean apply() {
		OutputCanvas out = mainPane.outputSystem.getCanvas((String)pane.outputBox.getSelectedItem());
		if (out==null) {
			System.err.println(pane.outputBox.getSelectedItem()+" not found");
			return false;
		}

		// backup output pane if used in other than first input op
		ComplexImage backup = null;
		try {
			for (int i=1; i<pane.operationPane.table.getRowCount(); i++) {
				if (((String)pane.outputBox.getSelectedItem()).equals(pane.operationPane.table.getValueAt(i, pane.operationPane.COLUMN_SOURCE))) {
					System.out.println("Backuping output pane since it's used as input.");
					backup = (ComplexImage) out.complexImage.clone();
					break;
				}
			}
		} catch (OutOfMemoryError err) {
			System.err.println(err);
			mainPane.showOutOfMem(frame, " to do this action.\nMore memory is needed because you are using the output for an input as well.\nSo I need to backup first");
			return false;
		}

		// don't reset if first op pane is output pane
		if (!pane.outputBox.getSelectedItem().equals(pane.operationPane.tableModel.getValueAt(0, 2))) {
			out.complexImage.reset();
		}
		
		if (out.originalCellImage!=null) {
			out.originalCellImage.flush();
			out.originalCellImage=null;
		}
		for (int i=0; i<pane.operationPane.table.getRowCount(); i++) {
			String op = (String) pane.operationPane.table.getValueAt(i, pane.operationPane.COLUMN_OP);
			String filter = (String) pane.operationPane.table.getValueAt(i, pane.operationPane.COLUMN_FILTER);
			String src = (String) pane.operationPane.table.getValueAt(i, pane.operationPane.COLUMN_SOURCE);
			int factor = op.charAt(0)=='-'?-1:1;
			int mode=0; 
			switch (filter.charAt(0)) {
				case 'C': mode = ComplexColor.MODE_COMPLEX; break;
				case 'R': mode = ComplexColor.MODE_REAL_ONLY; break;
				case 'I': mode = ComplexColor.MODE_IM_ONLY; break;
				case 'M': mode = ComplexColor.MODE_MAGNITUDE; break;
				case 'P': mode = ComplexColor.MODE_PHASE; break;
			}
			OutputCanvas canvas = mainPane.outputSystem.getCanvas(src);
			if (canvas!=null) {
				if (out==canvas) {
					if (i==0) {
						System.out.println(op+" "+src+"."+filter+" (self)");
						out.complexImage.selfOperation(mode, factor);
					}
					else {
						System.out.println(op+" "+src+"."+filter+" (backup)");
						out.complexImage.operation(backup, mode, factor);
					}
				}
				else {
					System.out.println(op+" "+src+"."+filter+" ");
					out.complexImage.operation(canvas.complexImage, mode, factor);
				}
			}
			else {
				GenericCanvas c2 = mainPane.drawSystem.getCanvas(src);
				if (c2==null) {
					System.err.println(src+" not found");
					return false;
				}
				else {
					if (c2 instanceof BackCanvas) {
						System.out.println(op+" "+src+"."+filter);
						BackCanvas bc = (BackCanvas) c2;
						out.complexImage.operation(bc.size, bc.dataRe, bc.dataIm, mode, factor);
						
					}
					else {
						System.out.println(op+" "+src+"."+filter);
						DrawCanvas dc = (DrawCanvas) c2;
						out.complexImage.operation(dc.size, dc.patternImage, mode, factor);
						
					}
				}
			}
		}
		out.complexImage.updateReIm2HSB();
		out.complexImage.updateHSB2image();
		out.updateImageBuffer();
		out.repaint();
		mainPane.outputSystem.showCanvas(out.name);
		if (backup!=null) backup.destroy();
		return true;
	}
	
	class ContentPane extends HVPanel.v {
		JComboBox outputBox;
		InputListPane lp1, lp2;
		JButton applyButton, closeButton;
		OperationPane operationPane;
		
		public ContentPane() {
			top();
			HVPanel.h inputSubPane = new HVPanel.h("Available inputs");
			lp1 = new InputListPane(mainPane.drawSystem.drawCanvas) {
				public void addCanvas(String name) {
					mainPane.drawSystem.addCanvas(name);
					//pane.outputBox.addItem(name);
				}
				public void closeCanvas(String name) {
					mainPane.drawSystem.closeCanvas(name);
					//pane.outputBox.removeItem(name);
					new CloseCanvasThread().start();
				}
				public BufferedImage getImage(String name) {
					return mainPane.drawSystem.getCanvas(name).getImage();
				}
				public void renameCanvas(String oldName, String newName) {
					mainPane.drawSystem.renameCanvas(oldName, newName);
				}
				public void showCanvas(String name) {
					mainPane.drawSystem.showCanvas(name);
				}
				public void open(File f) {
					mainPane.openFile(f, true);
				}
			};
			lp2 = new InputListPane(mainPane.outputSystem.outputCanvas) {
				public void addCanvas(String name) {
					mainPane.outputSystem.addCanvas(name, false);
					pane.outputBox.addItem(name);
				}
				public void closeCanvas(String name) {
					mainPane.outputSystem.closeCanvas(name);
					pane.outputBox.removeItem(name);
					new CloseCanvasThread().start();
				}
				public BufferedImage getImage(String name) {
					return mainPane.outputSystem.getCanvas(name).getImage();
				}
				public void renameCanvas(String oldName, String newName) {
					mainPane.outputSystem.renameCanvas(oldName, newName);
				}
				public void showCanvas(String name) {
					mainPane.outputSystem.showCanvas(name);
				}
				public void open(File f) {
					mainPane.openFile(f, false);
				}
			};
			inputSubPane.addSubPane(lp1);
			inputSubPane.putExtraSpace(10);
			inputSubPane.addSubPane(lp2);
			
			HVPanel.v memSubPane = new HVPanel.v("Memory used");
			memSubPane.expand(false);
			mainPane.memoryBar = new JProgressBar(0, (int)(Runtime.getRuntime().maxMemory()/1024));
			mainPane.memoryBar.setValue(0);
			mainPane.memoryBar.setStringPainted(true);
			memSubPane.addComp(mainPane.memoryBar);
			
			//System.out.println(mainPane.memoryBar.getUI());
			//mainPane.memoryBar.setUI(new MetalProgressBarUI());
//			try {
//				System.out.println(mainPane.memoryBar.getUI());
//				Method m = mainPane.memoryBar.getUI().getClass().getMethod("stopAnimationTimer", null);
//				m.invoke(mainPane.memoryBar.getUI(), null);
//			} catch (SecurityException e) {
//				System.out.println(e);
//			} catch (IllegalArgumentException e) {
//				System.out.println(e);
//			} catch (NoSuchMethodException e) {
//				System.out.println(e);
//			} catch (IllegalAccessException e) {
//				System.out.println(e);
//			} catch (InvocationTargetException e) {
//				System.out.println(e);
//			}
			//((ProgressBarUI)mainPane.memoryBar.getUI())
			
			HVPanel.v operationSubPane = new HVPanel.v("Operations");
			operationSubPane.addSubPane(operationPane=new OperationPane());
			
			HVPanel.h outputSubPane = new HVPanel.h("Output");
			outputBox = new DNDComboBox() {
			};
			outputSubPane.addComp(outputBox);
			
			//		for (int i=0; i<mainPane.drawSystem.drawCanvas.size(); i++) {
			//		outputBox.addItem(((GenericCanvas)mainPane.drawSystem.drawCanvas.get(i)).name);
			//	}
			for (int i=0; i<mainPane.outputSystem.outputCanvas.size(); i++) {
				outputBox.addItem(((GenericCanvas)mainPane.outputSystem.outputCanvas.get(i)).name);
			}
			
			Color c = outputBox.getBackground();
			outputBox.setBackground(Color.white);
			outputBox.getComponent(0).setBackground(c);
			
			
			//outputBox.getComponent(1).setBackground(Color.white);
			//System.out.println(outputBox.getComponent(1));
			
			//((CellRendererPane)outputBox.getComponent(1)).getComponent(0).setBackground(Color.white);
//		((JComponent)c).setOpaque(true);
			
			
//			outputBox.setEditable(true);
//			outputBox.setEditor(new BasicComboBoxEditor () {
//				public Component getEditorComponent() {
//					Component c = super.getEditorComponent();
//					c.setBackground(Color.white);
//					((JComponent)c).setOpaque(true);
//					return c;
////					JLabel l = new JLabel(outputBox.getSelectedItem().toString()) {
////						public JToolTip createToolTip() {return new MultiLineToolTip();}
////					};
//				}
//			});
			outputBox.setToolTipText(ToolTipTexts.outputOp);
			
			HVPanel.h applyCloseSubPane = new HVPanel.h();
			applyCloseSubPane.expand(false);
			applyCloseSubPane.putExtraSpace();
			applyCloseSubPane.addButton(closeButton=new JButton("Apply"));
			applyCloseSubPane.addButton(applyButton=new JButton("Close"));
			applyCloseSubPane.putExtraSpace();
			
			expand(true);
			addSubPane(inputSubPane);
			expand(false);
			addSubPane(memSubPane);
			bottom();
			addSubPane(outputSubPane);
			expand(true);
			addSubPane(operationSubPane);
			expand(false);
			addSubPane(applyCloseSubPane);
		}

		public void actionPerformed(ActionEvent e) {
			if (e.getActionCommand()=="Close") {
			  frame.setVisible(false);
			}
			if (e.getActionCommand()=="Apply") {
				boolean r = apply();
			  frame.setVisible(!r);
			}
		}
		
		abstract class InputListPane extends HVPanel.v {
			private DNDList list;
			private JButton newButton, openButton, saveButton, closeButton;
			
			abstract public void showCanvas(String name);
			abstract public void addCanvas(String name);
			abstract public void closeCanvas(String name);
			abstract public void renameCanvas(String oldName, String newName);
			abstract public BufferedImage getImage(String name);
			abstract public void open(File f);
			
			public InputListPane(Vector v) {
				expand(true);
				DefaultMutableListModel model = new DefaultMutableListModel();
				list = new DNDList(model) {
					public boolean onItemChanged(Object oldValue, Object newValue) {
						if (!mainPane.isTabNameUnique(newValue.toString())) return false;
						renameCanvas(oldValue.toString(), newValue.toString());
						return true;
					}
				};
				ListCellEditor editor = new DefaultListCellEditor(new JTextField());
				list.setListCellEditor(editor);
				for (int i=0; i<v.size(); i++) {
					model.addElement(v.get(i).toString());
				}
				list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				list.setLayoutOrientation(JList.VERTICAL);
				list.setVisibleRowCount(-1);	// showing all items if possible
				JScrollPane scroll = new JScrollPane(list);
				scroll.setPreferredSize(new Dimension(250, 150));
				addComp(scroll);

				expand(false);
				HVPanel.h p1 = new HVPanel.h();
				p1.addButton(newButton=new JButton("New"));
				p1.addButton(openButton=new JButton("Open"));
				p1.addButton(saveButton=new JButton("Save"));
				p1.addButton(closeButton=new JButton("Close"));
				addSubPane(p1);
				
				list.addListSelectionListener(new ListSelectionListener() {
					public void valueChanged(ListSelectionEvent e) {
						if (e.getValueIsAdjusting()==true) return;
						if (list.getSelectedIndex()==-1) return;
						showCanvas(list.getSelectedValue().toString());
					}
				});
			}
			public void actionPerformed(ActionEvent e) {
				if (e.getSource()==newButton) {
					try {
						String name="image "+nextIndex;
						addCanvas(name);
						list.addElement(name);
						nextIndex++;
					} catch (OutOfMemoryError err) {
						new OutOfMemThread().start();
						System.err.println("Not enough memory");
					}
				}
				else if (e.getSource()==openButton) {
					JFileChooser chooser = new JFileChooser();
					chooser.setFileFilter(new ImageInputFileFilter());
			    if(chooser.showOpenDialog(mainPane.applet.frame)==JFileChooser.APPROVE_OPTION) {
			    	open(chooser.getSelectedFile());
			    }
				}
				else if (e.getSource()==saveButton) {
					if (list.getSelectedIndex()!=-1) {
						JFileChooser chooser = new JFileChooser();
						chooser.setAcceptAllFileFilterUsed(false);
						chooser.addChoosableFileFilter(new JpegFileFilter());
						chooser.setFileFilter(new PngFileFilter());
						String s = list.getSelectedValue().toString();
						chooser.setSelectedFile(new File(s));
				    if(chooser.showSaveDialog(mainPane.applet.frame)==JFileChooser.APPROVE_OPTION) {
				    	FileFilter ff = chooser.getFileFilter();
				    	File f = chooser.getSelectedFile();
				    	if (ff instanceof JpegFileFilter) {
				    		if (f.getName().toLowerCase().indexOf(".jpeg")==-1 && f.getName().toLowerCase().indexOf(".jpg")==-1) {
				    			f = new File(f.getAbsoluteFile()+".jpeg");
				    		}
				    	}
				    	else {
				    		if (f.getName().toLowerCase().indexOf(".png")==-1) {
				    			f = new File(f.getAbsoluteFile()+".png");
				    		}
				    	}
							if (!f.exists() || JOptionPane.showConfirmDialog(mainPane.applet.frame, "Overwrite file "+f.getName()+" ?", "File already exists", JOptionPane.YES_NO_OPTION)==0) {
					    	try {
									ImageIO.write(getImage(s), ff instanceof JpegFileFilter?"JPEG":"PNG", f);
								} catch (Exception ex) {
									ex.printStackTrace();
						  		JOptionPane.showMessageDialog(frame, "Can't write file");
								}
							}
				    }
					}
				}
				else if (e.getSource()==closeButton) {
					if (list.getSelectedIndex()!=-1) {
						String s = list.getSelectedValue().toString();
						closeCanvas(s);
						operationPane.removeAll(s);
						list.removeElement();
					}
				}
			}
		}
			
		class OutOfMemThread extends Thread {
			public void run() {
				Color c = mainPane.memoryBar.getForeground();
				mainPane.memoryBar.setForeground(Color.red);
				mainPane.memoryBar.setValue(mainPane.memoryBar.getMaximum());
				mainPane.memoryBar.setString("OUT OF MEMORY !!");
				try {
					sleep(3000);
				} catch (InterruptedException e) {}
				mainPane.memoryBar.setForeground(c);
				mainPane.printUsedMem();
			}
		}

		
		class OperationPane extends HVPanel.v implements CellActionListener {
			public  final int COLUMN_OP = 0;
			public  final int COLUMN_FILTER = 1;
			public  final int COLUMN_SOURCE = 2;
			public  final int COLUMN_UP_BUTTON = 3;
			public  final int COLUMN_DOWN_BUTTON = 4;
			public  final int COLUMN_REMOVE_BUTTON = 5;
			private final String[] header = {"Op", "Filter", "Source", "", "", ""};
			private final boolean[] editable = {true, true, false, true, true, true};
			private final int[] width = {50, 120, -1, 40, 40, 80};
			private final TableCellRenderer[] renderers = {new centeredTextRenderer(), new centeredTextRenderer(), new centeredTextRenderer(), new ButtonRenderer(), new ButtonRenderer(), new ButtonRenderer()};
			private final TableCellEditor[] editors = {new OpComboBoxEditor(), new FilterComboBoxEditor(this), null, new ButtonEditor(this), new ButtonEditor(this), new ButtonEditor(this)};
			
			private DNDTable table;
			private DefaultTableModel tableModel;
			
			public OperationPane() {
				table = new DNDTable(tableModel=new DefaultTableModel() {
			    public boolean isCellEditable(int row, int col) {
			    	return editable==null?false:editable[col];
			    }
		      public Class getColumnClass(int c) {
		        return getValueAt(0, c).getClass();
		      }
				});

				for (int i=0; i<header.length; i++) {
					tableModel.addColumn(header[i]);
				}
				
				for (int i=0; i<header.length; i++) {
					TableColumn col = table.getColumnModel().getColumn(i);
					if (width!=null && width[i]!=-1) {
						col.setMinWidth(width[i]); 
						col.setMaxWidth(width[i]); 
						col.setPreferredWidth(width[i]); 
					}
					if (renderers[i]!=null) {
						col.setCellRenderer(renderers[i]);
					}
					if (editors[i]!=null) {
						col.setCellEditor(editors[i]);
					}
				}
				table.setRowHeight(20);
				table.setColumnSelectionAllowed(false);
				table.setRowSelectionAllowed(false);
				

				table.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
					public void valueChanged(ListSelectionEvent e) {
						if (e.getValueIsAdjusting()) return;
						if (table.getSelectedRow()==-1) return;
						String s = (String) table.getValueAt(table.getSelectedRow(), COLUMN_SOURCE);
						pane.lp1.showCanvas(s);
						pane.lp2.showCanvas(s);
					}
				});
				
				JScrollPane scroll = new JScrollPane(table) {
					public JToolTip createToolTip() {return new MultiLineToolTip();}
				};
				scroll.setPreferredSize(new Dimension(250, 150));
				scroll.setTransferHandler(table.getTransferHandler());
				scroll.setToolTipText(ToolTipTexts.emptyOpTable);
				addComp(scroll);
			}
			
			public void removeAll(String source) {
				for (int i=0; i<table.getRowCount(); i++) {
					if (source.equals(table.getValueAt(i, COLUMN_SOURCE))) {
						removeOpRow(i);
						i--;
					}
				}
			}
			public void removeOpRow(int i) {
				System.out.println("removeOpRow "+i);
				editors[COLUMN_REMOVE_BUTTON].stopCellEditing();
				tableModel.removeRow(i);
				if (i==0 && table.getRowCount()>0) {
					updateOp(0, (String)table.getValueAt(0, COLUMN_FILTER));
				}
			}
			
			public void cellActionPerformed(int row, int column) {
				if (column==COLUMN_FILTER) {
					String filter = (String)((FilterComboBoxEditor)editors[COLUMN_FILTER]).comboBox.getSelectedItem();
					updateOp(row, filter);
				}
				else if (column==COLUMN_UP_BUTTON) {
					if (row>0) {
						tableModel.moveRow(row, row, row-1);
						if (row==1) {
							updateOp(0, (String)table.getValueAt(0, COLUMN_FILTER));
							updateOp(1, (String)table.getValueAt(1, COLUMN_FILTER));
						}
					}
				}
				else if (column==COLUMN_DOWN_BUTTON) {
					if (row<tableModel.getRowCount()-1) tableModel.moveRow(row, row, row+1);
					if (row==0) {
						updateOp(0, (String)table.getValueAt(0, COLUMN_FILTER));
						updateOp(1, (String)table.getValueAt(1, COLUMN_FILTER));
					}
				}
				else if (column==COLUMN_REMOVE_BUTTON) {
					removeOpRow(row);
				}
			}
			
			private void updateOp(int row, String filter) {
				String currentOp = (String)table.getValueAt(row, COLUMN_OP);
				String s = ((OpComboBoxEditor)editors[COLUMN_OP]).getRenderValue(currentOp, row, filter);
				table.setValueAt(s, row, COLUMN_OP);
			}
			
			class ButtonRenderer extends JButton implements TableCellRenderer {
				public ButtonRenderer() {
					setMargin(new Insets(getMargin().top, 0, getMargin().bottom, 0));
				}
				
				public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
					setText((String)value);
					return this;
				}
			}
			
			class ButtonEditor extends AbstractCellEditor implements TableCellEditor, ActionListener {
				private JButton editor;
				JTable table;
				int currentRow, currentColumn;
				CellActionListener listener;

				public ButtonEditor(CellActionListener listener) {
					this.listener=listener;
					editor = new JButton();
					editor.setMargin(new Insets(editor.getMargin().top, 0, editor.getMargin().bottom, 0));
					editor.addActionListener(this);
					Insets margins = new Insets(0, 0, 0, 0);
					editor.setMargin(margins);
				}
				public void actionPerformed(ActionEvent e) {
					listener.cellActionPerformed(currentRow, currentColumn);
				}
				public Object getCellEditorValue() {
					return editor.getText();
				}
				public JButton editor() {
					return editor;
				}
				public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
					this.table=table;
					currentRow=row;
					currentColumn=column;
					editor.setText((String)value);
			    return editor;
				}
			}

			class centeredTextRenderer extends DefaultTableCellRenderer {
				public centeredTextRenderer() {
					setHorizontalAlignment(DefaultTableCellRenderer.CENTER);
				}				
			}
			
			class OpComboBoxEditor extends DefaultCellEditor implements TableCellEditor {
				JTable table;
				JComboBox comboBox;
				int currentRow;
				
				public OpComboBoxEditor() {
					super(new JComboBox());
					comboBox = ((JComboBox)getComponent());
				}
				
				public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
					this.table = table;
					currentRow = row;
					populate();
					return super.getTableCellEditorComponent(table, value, isSelected, row, column);
				}
				
				private void populate() {
					String filter = (String)table.getValueAt(currentRow, COLUMN_FILTER);
					int i = comboBox.getItemCount()==2?comboBox.getSelectedIndex():-1;
					comboBox.removeAllItems();
					if ("Magnitude".equals(filter)) {
						if (currentRow==0) comboBox.addItem("=");
						else comboBox.addItem("*");
						comboBox.setSelectedIndex(0);
					}
					else {
						if (currentRow==0) {
							comboBox.addItem("=");
							comboBox.addItem("= -");
						}
						else {
							comboBox.addItem("+");
							comboBox.addItem("-");
						}
						if (i!=-1) {
							comboBox.setSelectedIndex(i);
						}
					}
				}
				
				public String getRenderValue(String currentOp, int row, String filter) {
					if ("Magnitude".equals(filter)) {
						return row==0?"=":"*";
					}
					else {
						if (currentOp.indexOf('-')!=-1) {
							return row==0?"= -":"-";
						}
						else {
							return row==0?"=":"+";
						}
					}
				}
			}
			
			class FilterComboBoxEditor extends DefaultCellEditor implements TableCellEditor, ActionListener {
				CellActionListener listener;
				JComboBox comboBox;
				int currentRow, currentColumn;
				
				public FilterComboBoxEditor(CellActionListener listener) {
					super(new JComboBox(new String[]{"Complex", "Real part", "Imaginary part", "Phase", "Magnitude"}));
					this.listener = listener; 
					comboBox = ((JComboBox)getComponent());
					comboBox.addActionListener(this);
				}

				public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
					currentRow = row;
					currentColumn = column;
					return super.getTableCellEditorComponent(table, value, isSelected, row, column);
				}

				public void actionPerformed(ActionEvent e) {
					if (!comboBox.isValid()) return; //otherwise two times triggered !
					listener.cellActionPerformed(currentRow, currentColumn);
				}
			}
		}
	}
	
	
	class DNDTable extends JTable {
		public DNDTable(TableModel model) {
			super(model);
			setTransferHandler(new TransferHandler() {
				public boolean canImport(JComponent c, DataFlavor[] flavors) {
					for (int i=0; i<flavors.length; i++) {
						if (DataFlavor.stringFlavor.equals(flavors[i])) return true;
					}
					return false;
				}
				public boolean importData(JComponent c, Transferable t) {
					try {
						String s = (String)t.getTransferData(DataFlavor.stringFlavor);
						String op = ((DefaultTableModel) getModel()).getRowCount()==0?"=":"+";
						((DefaultTableModel) getModel()).addRow(new String[]{op, "Complex", s, "\u25b2", "\u25bc", "Remove"});
						return true;
					} catch (UnsupportedFlavorException e) {
					} catch (IOException e) {
					}
					return false;
				}
			});
		}
	}

	class DNDComboBox extends MultiLineToolTip.JComboBox {
		public DNDComboBox() {
			setTransferHandler(new TransferHandler() {
				public boolean canImport(JComponent c, DataFlavor[] flavors) {
					if (currentDragSource!=pane.lp2.list) return false;
					for (int i=0; i<flavors.length; i++) {
						if (DataFlavor.stringFlavor.equals(flavors[i])) return true;
					}
					return false;
				}
				public boolean importData(JComponent c, Transferable t) {
					try {
						setSelectedItem((String)t.getTransferData(DataFlavor.stringFlavor));
						return true;
					} catch (UnsupportedFlavorException e) {
					} catch (IOException e) {
					}
					return false;
				}
			});
		}
	}
	
	class DNDList extends JListMutable {
		public DNDList(ListModel model) {
			super(model);
			setTransferHandler(new TransferHandler() {
				protected Transferable createTransferable(JComponent c) {
					return new StringSelection(getSelectedValue().toString());
				}
				public boolean canImport(JComponent c, DataFlavor[] flavors) {
					return false;
				}
				public boolean importData(JComponent c, Transferable t) {
					return false;
				}
				public void exportAsDrag(JComponent c, InputEvent e, int action) {
					currentDragSource = DNDList.this;
					super.exportAsDrag(c, e, action);
				}
				public int getSourceActions(JComponent c) {
					return MOVE;
				}
			});
			addMouseMotionListener(new MouseMotionAdapter() {
		    public void mouseDragged(MouseEvent e) {
		    	JComponent c = (JComponent)e.getSource();
		    	TransferHandler th = c.getTransferHandler();
		    	th.exportAsDrag(c, e, TransferHandler.MOVE);
				}
			});
			addMouseListener(new MouseAdapter() {
				public void mouseClicked(MouseEvent e) {
					if (e.getClickCount()==2) {
						startEdit(new ActionEvent(DNDList.this, 0, null));
					}
				}
			});
			setDragEnabled(true);
		}
	}
}

class ImageInputFileFilter extends FileFilter {
	public String[] ext = {"jpeg", "jpg", "gif", "png"};

	public String getDescription() {
		return "*.JPEG, *.PNG, *.GIF";
	}
	public boolean accept(File f) {
		if (f.isDirectory()) return true;
    String extension = getExtension(f);
    if (extension==null) return false;
    for (int i=0; i<ext.length; i++) {
      if (extension.toLowerCase().equals(ext[i])) return true;
		}
    return false;
	}

	public String getExtension(File f) {
    String ext = null;
    String s = f.getName();
    int i = s.lastIndexOf('.');

    if (i > 0 &&  i < s.length() - 1) {
        ext = s.substring(i+1).toLowerCase();
    }
    return ext;
	}
}

class JpegFileFilter extends FileFilter {
	public String[] ext = {"jpeg", "jpg"};

	public String getDescription() {
		return "JPEG files";
	}
	public boolean accept(File f) {
		if (f.isDirectory()) return true;
    String extension = getExtension(f);
    if (extension==null) return false;
    for (int i=0; i<ext.length; i++) {
      if (extension.toLowerCase().equals(ext[i])) return true;
		}
    return false;
	}

	public String getExtension(File f) {
    String ext = null;
    String s = f.getName();
    int i = s.lastIndexOf('.');

    if (i > 0 &&  i < s.length() - 1) {
        ext = s.substring(i+1).toLowerCase();
    }
    return ext;
	}
}
class PngFileFilter extends FileFilter {
	public String[] ext = {"png"};

	public String getDescription() {
		return "PNG files";
	}
	public boolean accept(File f) {
		if (f.isDirectory()) return true;
    String extension = getExtension(f);
    if (extension==null) return false;
    for (int i=0; i<ext.length; i++) {
      if (extension.toLowerCase().equals(ext[i])) return true;
		}
    return false;
	}

	public String getExtension(File f) {
    String ext = null;
    String s = f.getName();
    int i = s.lastIndexOf('.');

    if (i > 0 &&  i < s.length() - 1) {
        ext = s.substring(i+1).toLowerCase();
    }
    return ext;
	}
}

interface CellActionListener {
	public void cellActionPerformed(int row, int column);
}

